package net.w_horse.excelpojo.xml;

import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.converter.CellFieldConverter;
import net.w_horse.excelpojo.converter.NothingConverter;
import net.w_horse.excelpojo.xml.tag.Use;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractCellSeekerFactoryBean implements FactoryBean {
	private ExcelPOJOBridge excelPOJOBridge;
	private String use = Use.NONE.getValue();
	private String range;
	private CellFieldConverter converter = new NothingConverter();

	abstract BeanDefinitionBuilder parse(Element element, CellSeekerFactoryBeanAcceptableXMLParser parser, ParserContext parserContext);

	@Override
	public boolean isSingleton() {
		return false;
	}

	public void setExcelPOJOBridge(ExcelPOJOBridge excelPOJOBridge) {
		this.excelPOJOBridge = excelPOJOBridge;
	}

	public ExcelPOJOBridge getExcelPOJOBridge() {
		return excelPOJOBridge;
	}

	public void setUse(String use) {
		this.use = use;
	}

	public String getUse() {
		return use;
	}

	public void setRange(String range) {
		this.range = range;
	}

	public String getRange() {
		return range;
	}

	public void setConverter(CellFieldConverter converter) {
		this.converter = converter;
	}

	public CellFieldConverter getConverter() {
		return converter;
	}

}
